# US Pathology Bundle - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Bundle**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-bundle-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-bundle-mappings.md) 
*  [Examples](StructureDefinition-us-pathology-bundle-examples.md) 
*  [XML](StructureDefinition-us-pathology-bundle.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-bundle.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-bundle.profile.ttl.md) 

## Resource Profile: US Pathology Bundle 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-bundle | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyExchangeBundle |

 
This document Bundle profile defines the structure for reporting to central cancer registry from a pathology environment and/or from an EHR enviroment. This profile is intended to be used for exchange of eCP data between LIS and EHR systems. 

**Usages:**

* Examples for this Profile: [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/us-pathology-bundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Key Elements Table](#tabs-key) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Terminology Bindings

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 16 elements(2 nested mandatory elements)
 Must-Support: 22 elements
 Fixed: 1 element

**Structures**

This structure refers to these other structures:

* [US Pathology Composition Laboratory Report(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-composition)](StructureDefinition-us-pathology-composition.md)
* [US Core Patient Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)
* [US Core Practitioner Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)
* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)
* [US Core Organization Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)
* [US Pathology Service Request(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-service-request)](StructureDefinition-us-pathology-service-request.md)
* [US Core Procedure Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-procedure.html)
* [US Pathology Specimen(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-specimen)](StructureDefinition-us-pathology-specimen.md)
* [US Pathology Diagnostic Report(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-diagnostic-report)](StructureDefinition-us-pathology-diagnostic-report.md)
* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)
* [US Core RelatedPerson Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-relatedperson.html)
* [US Core Encounter Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Bundle.entry

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 16 elements(2 nested mandatory elements)
 Must-Support: 22 elements
 Fixed: 1 element

**Structures**

This structure refers to these other structures:

* [US Pathology Composition Laboratory Report(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-composition)](StructureDefinition-us-pathology-composition.md)
* [US Core Patient Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)
* [US Core Practitioner Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)
* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)
* [US Core Organization Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)
* [US Pathology Service Request(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-service-request)](StructureDefinition-us-pathology-service-request.md)
* [US Core Procedure Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-procedure.html)
* [US Pathology Specimen(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-specimen)](StructureDefinition-us-pathology-specimen.md)
* [US Pathology Diagnostic Report(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-diagnostic-report)](StructureDefinition-us-pathology-diagnostic-report.md)
* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)
* [US Core RelatedPerson Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-relatedperson.html)
* [US Core Encounter Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Bundle.entry

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 

Other representations of profile: [CSV](StructureDefinition-us-pathology-bundle.csv), [Excel](StructureDefinition-us-pathology-bundle.xlsx), [Schematron](StructureDefinition-us-pathology-bundle.sch) 

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

