# Document DiagnosticReport Reference - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document DiagnosticReport Reference**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-composition-diagnosticReportReference-definitions.md) 
*  [Mappings](StructureDefinition-composition-diagnosticReportReference-mappings.md) 
*  [XML](StructureDefinition-composition-diagnosticReportReference.profile.xml.md) 
*  [JSON](StructureDefinition-composition-diagnosticReportReference.profile.json.md) 
*  [TTL](StructureDefinition-composition-diagnosticReportReference.profile.ttl.md) 

## Extension: Document DiagnosticReport Reference 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/composition-diagnosticReportReference | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DiagnosticReportReference |

This extension provides a reference to the DiagnosticReport instance that is associated with this Composition.

**Context of Use**

This extension may be used on the following element(s):

* Element ID Composition

**Usage info**

**Usages:**

* Use this Extension: [US Pathology Composition Laboratory Report](StructureDefinition-us-pathology-composition.md)
* Examples for this Extension: [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md) and [Composition/composition-invasive-carcinoma-of-the-breast](Composition-composition-invasive-carcinoma-of-the-breast.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/composition-diagnosticReportReference)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Text Summary](#tabs-summ) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Reference: This extension provides a reference to the DiagnosticReport instance that is associated with this Composition.

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Reference: This extension provides a reference to the DiagnosticReport instance that is associated with this Composition.

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

 

Other representations of profile: [CSV](StructureDefinition-composition-diagnosticReportReference.csv), [Excel](StructureDefinition-composition-diagnosticReportReference.xlsx), [Schematron](StructureDefinition-composition-diagnosticReportReference.sch) 

#### Constraints

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

