# Glandular/Tubular Differentiation Observation Example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Glandular/Tubular Differentiation Observation Example**

Publication Build: This will be filled in by the publication tooling

*  [Narrative Content](#) 
*  [XML](Observation-observation-glandular-differentiation.xml.md) 
*  [JSON](Observation-observation-glandular-differentiation.json.md) 
*  [TTL](Observation-observation-glandular-differentiation.ttl.md) 

## Example Observation: Glandular/Tubular Differentiation Observation Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**: [CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:f0d0b23b-f6a0-44d4-bfaf-ade1b485c0b0

**status**: Final

**category**: Question

**code**: Glandular (Acinar) / Tubular Differentiation

**subject**: [Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)

**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)

**performer**: [Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)

**value**: Score 2 (10 to 75% of tumor area forming glandular / tubular structures)

**derivedFrom**: [Observation Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note D)](Observation-observation-histologic-grade.md)

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

