# US Pathology Breast Invasive Carcinoma DiagnosticReport example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Breast Invasive Carcinoma DiagnosticReport example**

Publication Build: This will be filled in by the publication tooling

*  [Narrative Content](#) 
*  [XML](DiagnosticReport-diagnosticreport-breast-invasive-carcinoma.xml.md) 
*  [JSON](DiagnosticReport-diagnosticreport-breast-invasive-carcinoma.json.md) 
*  [TTL](DiagnosticReport-diagnosticreport-breast-invasive-carcinoma.ttl.md) 

## Example DiagnosticReport: US Pathology Breast Invasive Carcinoma DiagnosticReport example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md)

## Pathology Synoptic report (Pathology ) 

| | |
| :--- | :--- |
| Subject | Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, )) |
| When For | 2025-03-18 21:39:30+0000 |
| Performer | [PractitionerRole Primary Interpreter](PractitionerRole-practitionerrole-uspath-pathologist.md) |
| Identifier | [CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:7c9139fe-ddd5-49d9-b649-f37344e8b995 |

**Report Details**

* **Code**: [SPECIMEN](Observation-observation-section-specimen.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [TUMOR](Observation-observation-section-tumor.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2024-12-05
* **Code**: [Tumor Extent (Note H)](Observation-observation-section-tumor-extent.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18 14:52:02+0000 --> (ongoing)
* **Code**: [Lymph Nodes](Observation-observation-section-lymph-nodes.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [MARGINS (Note L)](Observation-observation-section-margins.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [REGIONAL LYMPH NODES (Note M)](Observation-observation-section-regional-lymph-nodes.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [Distant Metastasis](Observation-observation-section-distant-metastasis.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [PATHOLOGIC STAGE CLASSIFICATION (pTNM, AJCC 8th Edition) (Note M)](Observation-observation-section-ptnm-classification.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [ADDITIONAL FINDINGS (Note N)](Observation-observation-section-additional-findings.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [SPECIAL STUDIES](Observation-observation-section-special-studies.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [COMMENTS](Observation-observation-section-comments.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

