# Central Cancer Registry Reporting Pathology EHR Capability Statement - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Pathology EHR Capability Statement**

Publication Build: This will be filled in by the publication tooling

*  [Narrative Content](#) 
*  [XML](CapabilityStatement-capabilitystatement-central-cancer-registry-reporting-ehr-path.xml.md) 
*  [JSON](CapabilityStatement-capabilitystatement-central-cancer-registry-reporting-ehr-path.json.md) 
*  [TTL](CapabilityStatement-capabilitystatement-central-cancer-registry-reporting-ehr-path.ttl.md) 

## CapabilityStatement: Central Cancer Registry Reporting Pathology EHR Capability Statement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/CapabilityStatement/capabilitystatement-central-cancer-registry-reporting-ehr-path | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingPathologyEHRCapabilityStatement |

 
This profile defines the expected capabilities of the ‘‘EHR’’ actor when conforming to the Cancer Pathology Data Sharing IG. This role is responsible for allowing creation, modification and deletion of ServiceRequests that represent the request for Pathological analysis (and associated reports), and allows searching and retrieval of resources using US Core APIs. 

 [Raw OpenAPI-Swagger Definition file](capabilitystatement-central-cancer-registry-reporting-ehr-path.openapi.json) | [Download](capabilitystatement-central-cancer-registry-reporting-ehr-path.openapi.json) 

## Central Cancer Registry Reporting Pathology EHR Capability Statement

* Implementation Guide Version: 2.0.0 
* FHIR Version: 4.0.1 
* Supported Formats: `json`, `xml`
* Published on: 2022-06-13 
* Published by: HL7 International / Orders and Observations 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

The focus of the EHR is to allow creation, modification and deletion of ServiceRequests and allows searching and retrieval of resources using US Core APIs.

**Security**

> 

Implementations must meet the general security requirements documented in the security section of the implementation guide.


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [ServiceRequest](#ServiceRequest1-1) |   | y |  | y | y | y |  |  |  |  |

-------

#### Resource Conformance: supported ServiceRequest

Core FHIR Resource

[ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html)

Reference Policy

Interaction summary

* Supports 
`read`

Allows retrieval of a specific ServiceRequest instance.

`create`

Allows creation of a ServiceRequest resource instance.

`update`

Allows update of a ServiceRequest resource instance.

`delete`

Allows deletion of a ServiceRequest resource instance.


 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

