# US Pathology Exchange bundle example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Exchange bundle example**

Publication Build: This will be filled in by the publication tooling

*  [Narrative Content](#) 
*  [XML](Bundle-bundle-us-pathology-exchange.xml.md) 
*  [JSON](Bundle-bundle-us-pathology-exchange.json.md) 
*  [TTL](Bundle-bundle-us-pathology-exchange.ttl.md) 

## Example Bundle: US Pathology Exchange bundle example

**Document Details**

Profile: [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md)

Final Document at 2025-01-01 21:39:30+0000 by [Wise Owl](PractitionerRole-practitionerrole-uspath-practitioner-oncologist.md) for [Annie Oakley](Bundle-bundle-us-pathology-exchange.md#http-//hl7.org/fhir/us/cancer-reporting/Patient/patient-OakleyAnnie) in encounter [Encounter: identifier = http://example.com/fhir/encounters#123; status = finished; class = inpatient encounter (ActCode[9.0.0]#IMP); type = Pathology consultation, comprehensive, records and specimen with report](Bundle-bundle-us-pathology-exchange.md#http-//hl7.org/fhir/us/cancer-reporting/Encounter/encounter-uspath-specimen-collection)

-------

**Document Subject**

Profile: [US Core Patient Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)

Annie Oakley Female, DoB: 1990-06-01 ( SHID: 12446 (use: usual, ))

-------

-------

**Document Content**

## INVASIVE CARCINOMA OF THE BREAST: Resection

**Specimen**

**Procedure**

✓ Needle biopsy
__ Fine needle aspiration
__ Other (specify): ___________________
__ Not specified

**Specimen Laterality**

__ Right
✓ Left
__ Not specified

**+Tumor Site (select all that apply)**

__ Upper outer quadrant
__ Lower outer quadrant
__ Upper inner quadrant
__ Lower inner quadrant
__ Central
__ Nipple
✓ Clock position

**Specify Clock Position (select all that apply)**

__ 1 o'clock
__ 2 o'clock
__ 3 o'clock
__ 4 o'clock
__ 5 o'clock
__ 6 o'clock
__ 7 o'clock
✓ 8 o'clock
__ 9 o'clock
__ 10 o'clock
__ 11 o'clock
__ 12 o'clock

__ Specify distance from nipple in Centimeters (cm): _______________ cm
__ Other (specify): ___________________
__ Not specified

**Histologic Type (Note A)**

__ No residual invasive carcinoma
✓ Invasive carcinoma of no special type (ductal)
__ Micro-invasive carcinoma
__ Invasive lobular carcinoma
__ Invasive carcinoma with mixed ductal and lobular features
__ Invasive carcinoma with features of (specify): ___________________
__ Tubular carcinoma
__ Invasive cribriform carcinoma
__ Mucinous carcinoma
__ Invasive micropapillary carcinoma
__ Apocrine adenocarcinoma
__ Metaplastic carcinoma
__ Encapsulated papillary carcinoma with invasion
__ Solid papillary carcinoma with invasion
__ Intraductal papillary adenocarcinoma with invasion
__ Adenoid cystic carcinoma
__ Neuroendocrine tumor
__ Neuroendocrine carcinoma
__ Invasive carcinoma, type cannot be determined: ___________________
__ Other histologic type not listed (specify): ___________________
__ Histologic Type Comment: ___________________

**Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note B)**

__ Not applicable (no residual carcinoma or microinvasion only)
✓ Nottingham Score

**Glandular (Acinar) / Tubular Differentiation**

✓ Score 1 (greater than 75% of tumor area forming glandular / tubular structures)
__ Score 2 (10% to 75% of tumor area forming glandular / tubular structures)
__ Score 3 (less than 10% of tumor area forming glandular / tubular structures)
__ Score cannot be determined

**Nuclear Pleomorphism**

__ Score 1 (Nuclei small with little increase in size in comparison with normal breast epithelial cells, regular outlines, uniform nuclear chromatin, little variation in size)
✓ Score 2 (Cells larger than normal with open vesicular nuclei, visible nucleoli, and moderate variability in both size and shape)
__ Score 3 (Vesicular nuclei, often with prominent nucleoli, exhibiting marked variation in size and shape, occasionally with very large and bizarre forms)
__ Score cannot be determined

**Mitotic Rate**

See Table 1 in*CAP Protocol*
✓ Score 1
__ Score 2
__ Score 3
__ Score cannot be determined: ___________________

**Overall Grade**

✓ Grade 1 (scores of 3, 4, or 5)

**Tumor Size (Note E)**

__ No residual invasive carcinoma
__ Microinvasion only (less than or equal to 1 mm)
✓ Greatest dimension of largest invasive focus greater than 1 mm (specify exact measurement in Millimeters (mm)): **13.0** mm
__ Additional Dimension in Millimeters (mm): ____ × ____ mm
__ Size of largest invasive focus cannot be determined (explain): ___________________

**+Tumor Focality (Note F)**

✓ Single focus of invasive carcinoma
__ Multiple foci of invasive carcinoma
__ Number of Foci
__ Specify number: ___________________
__ At least: ___________________
__ Cannot be determined

**Ductal Carcinoma In Situ (DCIS) (Note G)**

✓ Not identified
__ Present
__ Present (in close proximity to invasive carcinoma)
__ Present only after presurgical therapy and prior to therapy the cancer is classified as pTis
__ Negative for extensive intraductal component (EIC)
__ Positive for extensive intraductal component (EIC)
__ Only DCIS is present after presurgical (neoadjuvant) therapy

**+Size (Extent) of DCIS**

__ Estimated size (extent) of DCIS is at least in Millimeters (mm): _____ mm
__ Additional Dimension in Millimeters (mm): _____ × _____ mm
__ Cannot be determined

**Tumor Extent (Note H)**

__ Tumor Extent (required only if skin, nipple, or skeletal muscle are present and involved) (select all that apply)
✓ Not applicable (skin, nipple, and skeletal muscle are absent OR are uninvolved)

**Margin Status for Invasive Carcinoma (required only if residual invasive carcinoma is present in specimen)**

__ Not applicable (residual invasive carcinoma in specimen is absent)
✓ All margins negative for invasive carcinoma

**Distance from Invasive Carcinoma to Closest Margin**

Specify in Millimeters (mm):

✓ Exact distance: ______________ mm
__ Less than: ______________ mm
__ Greater than: ______________ mm
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**+Closest Margin(s) to Invasive Carcinoma (select all that apply)**

__ Anterior
__ Posterior
__ Superior
__ Inferior
__ Medial
✓ Lateral
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Margin(s) Involved by Invasive Carcinoma (select all that apply)**

__ Anterior (specify extent): ______________
__ Posterior (specify extent): ______________
__ Superior (specify extent): ______________
__ Inferior (specify extent): ______________
__ Medial (specify extent): ______________
__ Lateral (specify extent): ______________
__ Other (specify margin(s) and extent): ______________
__ Cannot be determined (explain): ______________
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Regional Lymph Node Status**

__ Not applicable (no regional lymph nodes submitted or found)
✓ Regional lymph nodes present
__ All regional lymph nodes negative for tumor
__ Tumor present in regional lymph node(s)

**Number of Lymph Nodes with Macrometastases (greater than 2 mm)**

__ Exact number (specify): ______________
__ At least (specify): ______________
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Number of Lymph Nodes with Micrometastases (greater than 0.2 mm to 2 mm and / or greater than 200 cells)**

__ Exact number (specify): ______________
__ At least (specify): ______________
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Number of Lymph Nodes with Isolated Tumor Cells (0.2 mm or less OR 200 cells or less) (required only if applicable)**

__ Not applicable
__ Exact number (specify): ______________
__ At least (specify): ______________
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Size of Largest Nodal Metastatic Deposit**

Specify in Millimeters (mm):

__ Exact size: ______________ mm
__ Less than: ______________ mm
__ Greater than: ______________ mm
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Extranodal Extension**

__ Not identified
__ Present, 2 mm or less
__ Present, greater than 2 mm

**+Specify Amount:**

__ Present
__ Cannot be determined: ______________
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Total Number of Lymph Nodes Examined (sentinel and non-sentinel)**

✓ Exact number (specify): ______________
__ At least (specify): ______________
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Number of Sentinel Nodes Examined (if applicable)**

__ Not applicable
✓ Exact number (specify): ______________
__ At least (specify): ______________
__ Other (specify): ______________
__ Cannot be determined (explain): ______________

**Distant Site(s) Involved, if applicable (select all that apply)**

✓ Not applicable
__ Non-regional lymph node(s) (specify, if possible): ______________
__ Lung: ______________
__ Liver: ______________
__ Bone: ______________
__ Brain: ______________
__ Other (specify): ______________
__ Cannot be determined

**Modified Classification (required only if applicable) (select all that apply)**

__ Not applicable
__ y (post-neoadjuvant therapy)
__ r (recurrence)

**pT Category**

__ pT not assigned (cannot be determined based on available pathological information)
__ pT0: No evidence of primary tumor
__ pTis (DCIS): Ductal carcinoma in situ
__ pTis (Paget): Paget disease NOT associated with invasive carcinoma and / or carcinoma in situ (DCIS) in the underlying breast parenchyma
__ pT1: Tumor less than or equal to 20 mm in greatest dimension
__ pT1mi: Tumor less than or equal to 1 mm in greatest dimension
__ pT1a: Tumor greater than 1 mm but less than or equal to 5 mm in greatest dimension
✓ pT1b: Tumor greater than 5 mm but less than or equal to 10 mm in greatest dimension
__ pT1c: Tumor greater than 10 mm but less than or equal to 20 mm in greatest dimension
__ pT2: Tumor greater than 20 mm but less than or equal to 50 mm in greatest dimension
__ pT3: Tumor greater than 50 mm in greatest dimension
__ pT4: Tumor of any size with direct extension to the chest wall and/or to the skin (ulceration or skin nodules)
__ pT4a: Extension to the chest wall; invasion of or adherence to pectoralis muscle in the absence of invasion of chest wall structures does not qualify as T4
__ pT4b: Ulceration and/or ipsilateral satellite nodules and/or edema (including peau d'orange) of the skin which do not meet the criteria for inflammatory carcinoma
__ pT4c: Both T4a and T4b are present
__ pT4d: Inflammatory carcinoma
__ pT4 (subcategory cannot be determined)

**pN Category**

__ pN not assigned (no nodes submitted or found)
__ pN not assigned (cannot be determined based on available pathological information)
✓ pN0: No regional lymph node metastasis identified or ITCs only
__ pN0 (i+): ITCs only (malignant cell clusters no larger than 0.2 mm) in regional lymph node(s)
__ pN0 (mol+): Positive molecular findings by reverse transcriptase polymerase chain reaction (RT-PCR); no ITCs detected
__ pN1: Metastases in 1 to 3 axillary lymph nodes, at least one metastasis larger than 2.0 mm
__ pN1mi: Micrometastases (approximately 200 cells, larger than 0.2 mm, but none larger than 2.0 mm)
__ pN1a: Metastases in 1 to 3 axillary lymph nodes, at least one metastasis larger than 2.0 mm
__ pN1b: Metastases in internal mammary sentinel nodes, excluding ITCs
__ pN1c: pN1a and pN1b combined
__ pN2: Metastases in 4-9 axillary lymph nodes; or in clinically detected internal mammary lymph nodes with negative axillary nodes
__ pN2a: Metastases in 4-9 axillary lymph nodes (at least one tumor deposit larger than 2.0 mm)
__ pN2b: Metastases in clinically detected internal mammary lymph nodes with or without microscopic confirmation; with pathologically negative axillary lymph nodes
__ pN3: Metastases in 10 or more axillary lymph nodes; or in infraclavicular (level III axillary) lymph nodes; or in clinically detected ipsilateral internal mammary lymph nodes with one or more positive level I, II axillary lymph nodes; or in more than 3 axillary lymph nodes and in internal mammary lymph nodes with microscopic disease or macroscopic disease detected by sentinel lymph node biopsy but not clinically detected; or in ipsilateral supraclavicular lymph nodes
__ pN3a: Metastases in 10 or more axillary lymph nodes (at least one tumor deposit larger than 2.0 mm); or metastases to the infraclavicular (level III axillary lymph) nodes
__ pN3b: pN1a or pN2a in the presence of cN2b (positive internal mammary nodes by imaging); or pN2a in the presence of pN1b
__ pN3c: Metastases in ipsilateral supraclavicular lymph nodes

**N Suffix (required only if applicable)**

__ Not applicable
__ (sn) Sentinel node(s) evaluated. If 6 or more nodes (sentinel or nonsentinel) are removed, this modifier should not be used
__ (f) Nodal metastasis confirmed by fine needle aspiration or core needle biopsy
__ (m) Multiple primary synchronous tumors in a single organ

**ADDITIONAL FINDINGS (Note O)**

+Additional Findings (specify): ________________

**SPECIAL STUDIES**

The CAP Breast Biomarker Template should be used for reporting biomarkers requested for this resection specimen. Pending biomarker studies should be listed in the Comments section of this report.

**+Breast Biomarker Studies Performed on Previous Biopsy (select all that apply)**

✓ Estrogen Receptor (ER)

**Estrogen Receptor (ER) Status**

__ Positive (greater than 10% of cells demonstrate nuclear positivity)
__ Low Positive (1-10% of cells with nuclear positivity)
__ Negative
✓ Cannot be determined (indeterminate)

__ Progesterone Receptor (PgR)

✓ HER2 (by immunohistochemistry)

✓ Negative (Score 0)
__ Negative (Score 1+)
__ Equivocal (Score 2+)
__ Positive (Score 3+)
__ Cannot be determined (indeterminate)

__ HER2 (by in situ hybridization)

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/DiagnosticReport/diagnosticreport-breast-invasive-carcinoma

Resource DiagnosticReport:

> 

Profile: [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md)

## Pathology Synoptic report (Pathology ) 

| | |
| :--- | :--- |
| Subject | Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, )) |
| When For | 2025-03-18 21:39:30+0000 |
| Performer | [PractitionerRole Primary Interpreter](PractitionerRole-practitionerrole-uspath-pathologist.md) |
| Identifier | [CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:7c9139fe-ddd5-49d9-b649-f37344e8b995 |

**Report Details**

* **Code**: [SPECIMEN](Observation-observation-section-specimen.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [TUMOR](Observation-observation-section-tumor.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2024-12-05
* **Code**: [Tumor Extent (Note H)](Observation-observation-section-tumor-extent.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18 14:52:02+0000 --> (ongoing)
* **Code**: [Lymph Nodes](Observation-observation-section-lymph-nodes.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [MARGINS (Note L)](Observation-observation-section-margins.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [REGIONAL LYMPH NODES (Note M)](Observation-observation-section-regional-lymph-nodes.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [Distant Metastasis](Observation-observation-section-distant-metastasis.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [PATHOLOGIC STAGE CLASSIFICATION (pTNM, AJCC 8th Edition) (Note M)](Observation-observation-section-ptnm-classification.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [ADDITIONAL FINDINGS (Note N)](Observation-observation-section-additional-findings.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [SPECIAL STUDIES](Observation-observation-section-special-studies.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18
* **Code**: [COMMENTS](Observation-observation-section-comments.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2025-03-18


-------

Entry 3 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-specimen

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:6ac70450-cc74-4a8e-8699-9ffab1e0ac24**status**: Final**category**:Section**code**:SPECIMEN**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:
* [Observation Procedure (Note A)](Observation-observation-procedure-breast-excision.md)
* [Observation Specimen Laterality](Observation-observation-specimen-laterality.md)

-------

Entry 4 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-tumor

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:cb7657fb-8127-41ef-9912-8f6fc52a5f85**status**: Final**category**:Section**code**:TUMOR**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2024-12-05**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:
* [Observation Tumor Site (Note B)](Observation-observation-tumor-site.md)
* [Observation Histologic Type (Note C)](Observation-observation-histologic-type.md)
* [Observation Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note D)](Observation-observation-histologic-grade.md)
* [Observation Tumor Size (Note E)](Observation-observation-tumor-size.md)
* [Observation Tumor Focality (Note F)](Observation-observation-tumor-focality.md)
* [Observation Ductal Carcinoma In Situ (DCIS) (Note G)](Observation-observation-ductal-carcinoma.md)

-------

Entry 5 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-lymph-nodes

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f**status**: Final**category**:Section**code**:Lymph Nodes**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)

-------

Entry 6 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-margins

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f**status**: Final**category**:Section**code**:MARGINS (Note L)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:[Observation Margin Status for Invasive Carcinoma](Observation-observation-margins-margin-status-for-invasive-carcinoma.md)

-------

Entry 7 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-regional-lymph-nodes

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f**status**: Final**category**:Section**code**:REGIONAL LYMPH NODES (Note M)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:[Observation Regional Lymph Node Status](Observation-observation-regional-lymph-node-status.md)

-------

Entry 8 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-distant-metastasis

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f**status**: Final**category**:Section**code**:Distant Metastasis**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:[Observation DISTANT METASTASIS](Observation-observation-distant-metastasis.md)

-------

Entry 9 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-ptnm-classification

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:4958b036-f88e-470b-b225-38e9fe6b6541**status**: Final**category**:Section**code**:PATHOLOGIC STAGE CLASSIFICATION (pTNM, AJCC 8th Edition) (Note M)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:
* [Observation pT Category](Observation-observation-ptnm-classification-pT-Category.md)
* [Observation pN Category](Observation-observation-ptnm-classification-pN-Category.md)

-------

Entry 10 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-additional-findings

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:7c9139fe-ddd5-49d9-b649-f37344e8b995**status**: Final**category**:Section**code**:ADDITIONAL FINDINGS (Note N)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:[Observation Additional Findings (specify)](Observation-observation-additional-findings-specify.md)

-------

Entry 11 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-additional-findings-specify

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:9cfaa1f6-f0af-4e66-8fe0-130b2143b135**status**: Final**category**:Question**code**:Additional Findings (specify)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**derivedFrom**:[Observation ADDITIONAL FINDINGS (Note N)](Observation-observation-section-additional-findings.md)

-------

Entry 12 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-special-studies

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:87335ed1-f468-4061-a401-8b8e3b54cf4c**status**: Final**category**:Section**code**:SPECIAL STUDIES**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:[Observation Breast Biomarker Testing Performed on Previous Biopsy](Observation-observation-special-studies-breast-biomarker.md)

-------

Entry 13 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-comments

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/uuid:c3189cd4-33a0-447f-9bbf-2b225e2aa305**status**: Final**category**:Section**code**:COMMENTS**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)

-------

Entry 14 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-procedure-breast-excision

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:7c9139fe-ddd5-49d9-b649-f37344e8b995**status**: Final**category**:Question**code**:Procedure (Note A)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Excision (less than total mastectomy)**derivedFrom**:[Observation SPECIMEN](Observation-observation-section-specimen.md)

-------

Entry 15 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-specimen-laterality

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:4bcd147c-ff3d-4eb3-bcd3-9d679bd1ad1b**status**: Final**category**:Question**code**:Specimen Laterality**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Right**derivedFrom**:[Observation SPECIMEN](Observation-observation-section-specimen.md)

-------

Entry 16 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-tumor-site

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:79ab15c8-4b0e-48e5-a477-7f72e62c002b**status**: Final**category**:Question**code**:Tumor Site (Note B)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:[Observation Clock position](Observation-observation-clock-position.md)**derivedFrom**:[Observation TUMOR](Observation-observation-section-tumor.md)

-------

Entry 17 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-clock-position

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:ab9326c2-e1fe-4ba0-873c-41c923c7f772**status**: Final**category**:Question**code**:Clock position**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Clock position**hasMember**:[Observation Specify Clock Position](Observation-observation-clock-position-8.md)**derivedFrom**:[Observation Tumor Site (Note B)](Observation-observation-tumor-site.md)

-------

Entry 18 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-clock-position-8

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:bf778f95-b1a8-4674-a73e-1f2dc0bfbdc4**status**: Final**category**:Question**code**:Specify Clock Position**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-13 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:8 o'clock

-------

Entry 19 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-histologic-type

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:cb7657fb-8127-41ef-9912-8f6fc52a5f85**status**: Final**category**:Question**code**:Histologic Type (Note C)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Invasive carcinoma of no special type (ductal)

-------

Entry 20 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-histologic-grade

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:cb7657fb-8127-41ef-9912-8f6fc52a5f85**status**: Final**category**:Question**code**:Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note D)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Nottingham Score**hasMember**:
* [Observation Glandular (Acinar) / Tubular Differentiation](Observation-observation-glandular-differentiation.md)
* [Observation Nuclear Pleomorphism](Observation-observation-nuclear-pleomorphism.md)
* [Observation Mitotic Rate](Observation-observation-mitotic-rate.md)
* [Observation Overall Grade](Observation-observation-overall-grade.md)
**derivedFrom**:[Observation TUMOR](Observation-observation-section-tumor.md)

-------

Entry 21 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-glandular-differentiation

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:f0d0b23b-f6a0-44d4-bfaf-ade1b485c0b0**status**: Final**category**:Question**code**:Glandular (Acinar) / Tubular Differentiation**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Score 2 (10 to 75% of tumor area forming glandular / tubular structures)**derivedFrom**:[Observation Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note D)](Observation-observation-histologic-grade.md)

-------

Entry 22 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-nuclear-pleomorphism

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:77d0563d-3685-4316-9a81-fa7d04d0d8d2**status**: Final**category**:Question**code**:Nuclear Pleomorphism**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Score 2 (Cells larger than normal with open vesicular nuclei, visible nucleoli, and moderate variability in both size and shape)**derivedFrom**:[Observation Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note D)](Observation-observation-histologic-grade.md)

-------

Entry 23 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-mitotic-rate

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:814dd523-9284-4edb-8831-fc1c440e4979**status**: Final**category**:Question**code**:Mitotic Rate**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Score 1**derivedFrom**:[Observation Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note D)](Observation-observation-histologic-grade.md)

-------

Entry 24 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-overall-grade

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:ddea4bbc-a3e7-477b-b279-57cf5071e0b9**status**: Final**category**:Question**code**:Overall Grade**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2024-12-05 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Grade 1 (scores of 3, 4 or 5)**derivedFrom**:[Observation Histologic Grade (Nottingham Histologic Score) (required only if applicable) (Note D)](Observation-observation-histologic-grade.md)

-------

Entry 25 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-tumor-size

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:66153175-f304-443e-99cb-4058f350248b**status**: Final**category**:Question**code**:Tumor Size (Note E)**subject**:[Annie Oakley](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[PractitionerRole Primary Interpreter](PractitionerRole-practitionerrole-uspath-pathologist.md)**value**:Greatest dimension of largest invasive focus greater than 1 mm (specify exact measurement in Millimeters (mm))**hasMember**:[Observation Additional Dimension in Millimeters (mm)](Observation-observation-additional-dimension.md)**derivedFrom**:[Observation TUMOR](Observation-observation-section-tumor.md)

-------

Entry 26 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-additional-dimension

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:18c9ea9c-ddf2-400d-adea-07c97dd7b016**status**: Final**category**:Question**code**:Additional Dimension in Millimeters (mm)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**: 13**derivedFrom**:[Observation Tumor Size (Note E)](Observation-observation-tumor-size.md)

-------

Entry 27 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-tumor-focality

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:309f8a1c-8311-4751-8718-4b2573a09633**status**: Final**category**:Question**code**:Tumor Focality (Note F)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Single focus of invasive carcinoma**derivedFrom**:[Observation TUMOR](Observation-observation-section-tumor.md)

-------

Entry 28 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-ductal-carcinoma

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:c2f916f9-7438-4ba6-9cba-9e9064edbe3c**status**: Final**category**:Question**code**:Ductal Carcinoma In Situ (DCIS) (Note G)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Not identified**derivedFrom**:[Observation TUMOR](Observation-observation-section-tumor.md)

-------

Entry 29 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-section-tumor-extent

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:1dc64a64-e4f1-4996-87df-28b76446c35a**status**: Final**category**:Section**code**:Tumor Extent (Note H)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**derivedFrom**:[Observation TUMOR](Observation-observation-section-tumor.md)

-------

Entry 30 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-margins-margin-status-for-invasive-carcinoma

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:ee170d9a-d5b5-481a-ac58-52dea11955b4**status**: Final**category**:Question**code**:Margin Status for Invasive Carcinoma**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:All margins negative for invasive carcinoma**hasMember**:
* [Observation Distance from Invasive Carcinoma to Closest Margin](Observation-observation-margins-distance-to-closest-margin.md)
* [Observation Closest Margin(s) to Invasive Carcinoma](Observation-observation-margins-closest-margin-to-invasive-carcinoma.md)
**derivedFrom**:[Observation MARGINS (Note L)](Observation-observation-section-margins.md)

-------

Entry 31 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-margins-distance-to-closest-margin

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:7069b59e-9414-4838-bd6d-674ef97c414c**status**: Final**category**:Question**code**:Distance from Invasive Carcinoma to Closest Margin**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Exact distance**derivedFrom**:[Observation Margin Status for Invasive Carcinoma](Observation-observation-margins-margin-status-for-invasive-carcinoma.md)

-------

Entry 32 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-margins-closest-margin-to-invasive-carcinoma

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:c12982a8-541c-469a-b016-9468d58eb858**status**: Final**category**:Question**code**:Closest Margin(s) to Invasive Carcinoma**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Lateral**derivedFrom**:[Observation MARGINS (Note L)](Observation-observation-section-margins.md)

-------

Entry 33 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-regional-lymph-node-status

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f**status**: Final**category**:Question**code**:Regional Lymph Node Status**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Regional lymph nodes present**hasMember**:
* [Observation Total Number of Lymph Nodes Examined (sentinel and non-sentinel)](Observation-observation-regional-lymph-nodes-number-examined.md)
* [Observation Number of Sentinel Nodes Examined](Observation-observation-regional-lymph-nodes-number-sentinel.md)
**derivedFrom**:[Observation REGIONAL LYMPH NODES (Note M)](Observation-observation-section-regional-lymph-nodes.md)

-------

Entry 34 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-regional-lymph-nodes-number-examined

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a903ae85-913a-4c9b-94cb-c6a1e00340e3**status**: Final**category**:Question**code**:Total Number of Lymph Nodes Examined (sentinel and non-sentinel)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Exact number (specify)**derivedFrom**:[Observation Regional Lymph Node Status](Observation-observation-regional-lymph-node-status.md)

-------

Entry 35 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-regional-lymph-nodes-number-sentinel

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:25b43d87-bad0-4779-91c8-352ad2f778ce**status**: Final**category**:Question**code**:Number of Sentinel Nodes Examined**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Exact number (specify)**derivedFrom**:[Observation Regional Lymph Node Status](Observation-observation-regional-lymph-node-status.md)

-------

Entry 36 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-distant-metastasis

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f**status**: Final**category**:Section**code**:DISTANT METASTASIS**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:[Observation Distant Site(s) Involved, if applicable](Observation-observation-distant-metastasis-distant-sites.md)

-------

Entry 37 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-distant-metastasis-distant-sites

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f**status**: Final**category**:Question**code**:Distant Site(s) Involved, if applicable**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Not applicable**derivedFrom**:[Observation DISTANT METASTASIS](Observation-observation-distant-metastasis.md)

-------

Entry 38 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-ptnm-classification-pT-Category

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:4958b036-f88e-470b-b225-38e9fe6b6541**status**: Final**category**:Question**code**:pT Category**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:pT1b: Tumor greater than 5 mm but less than or equal to 10 mm in greatest dimension**derivedFrom**:[Observation PATHOLOGIC STAGE CLASSIFICATION (pTNM, AJCC 8th Edition) (Note M)](Observation-observation-section-ptnm-classification.md)

-------

Entry 39 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-ptnm-classification-pN-Category

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:7164b3a9-3061-4f7f-9bbb-2a4e6980d665**status**: Final**category**:Question**code**:pN Category**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:pN0: No regional lymph node metastasis identified or ITCs only#**derivedFrom**:[Observation PATHOLOGIC STAGE CLASSIFICATION (pTNM, AJCC 8th Edition) (Note M)](Observation-observation-section-ptnm-classification.md)

-------

Entry 40 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-special-studies-breast-biomarker

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:3a313831-c8c5-44e7-8df2-af1b47b9879f**status**: Final**category**:Question**code**:Breast Biomarker Testing Performed on Previous Biopsy**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**hasMember**:
* [Observation Estrogen Receptor (ER)](Observation-observation-special-studies-estrogen-receptor.md)
* [Observation HER2 (by immunohistochemistry)](Observation-observation-special-studies-her2.md)
**derivedFrom**:[Observation SPECIAL STUDIES](Observation-observation-section-special-studies.md)

-------

Entry 41 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-special-studies-estrogen-receptor

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:8e615e45-6a49-46d9-8dfe-e84f19c29a92**status**: Final**category**:Question**code**:Estrogen Receptor (ER)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-05**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Estrogen Receptor (ER)**hasMember**:[Observation Estrogen Receptor (ER) Status](Observation-observation-special-studies-estrogen-receptor-status.md)**derivedFrom**:[Observation Breast Biomarker Testing Performed on Previous Biopsy](Observation-observation-special-studies-breast-biomarker.md)

-------

Entry 42 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-special-studies-estrogen-receptor-status

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:32bd9a78-878b-4fda-a6bd-c0bc58109fe7**status**: Final**category**:Question**code**:Estrogen Receptor (ER) Status**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Cannot be determined (indeterminate)**derivedFrom**:[Observation Estrogen Receptor (ER)](Observation-observation-special-studies-estrogen-receptor.md)

-------

Entry 43 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-special-studies-her2

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:deacb965-18d3-4451-a27f-0e26e7a9e5a2**status**: Final**category**:Question**code**:HER2 (by immunohistochemistry)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Stains Alot](Practitioner-practitioner-pathologist.md)**hasMember**:[Observation HER2 (by immunohistochemistry)](Observation-observation-special-studies-negative.md)**derivedFrom**:[Observation Breast Biomarker Testing Performed on Previous Biopsy](Observation-observation-special-studies-breast-biomarker.md)

-------

Entry 44 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Observation/observation-special-studies-negative

Resource Observation:

> 

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**:[CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:1ca2fb51-1752-4489-a4b0-5c0dccc043e5**status**: Final**category**:Question**code**:HER2 (by immunohistochemistry)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**effective**: 2025-03-18**performer**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**value**:Negative (Score 0)**derivedFrom**:[Observation HER2 (by immunohistochemistry)](Observation-observation-special-studies-her2.md)

-------

Entry 45 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Specimen/specimen-breast

Resource Specimen:

> 

Profile: [US Pathology Specimen](StructureDefinition-us-pathology-specimen.md)

**identifier**:`https://www.example.org/some-lis/fhir/specimen-identifier-provisioner`/987654321**accessionIdentifier**:`https://www.example.org/some-lis/fhir/specimen-identifier-provisioner`/987654321X**type**:Tissue specimen (specimen)**request**:[ServiceRequest Surgical pathology study](ServiceRequest-servicerequest-cancer-path.md)

### Collections

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Collected[x]** | **Method** | **BodySite** |
| * | 2025-03-18 17:00:14-0500 | Excision (procedure) | No display for Specimen.collection.bodySite (concept: Breast structure (body structure)) |

> **container**

-------

Entry 46 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Patient/patient-OakleyAnnie

Resource Patient:

> 

Profile: [US Core Patient Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)

Annie Oakley Female, DoB: 1990-06-01 ( SHID: 12446 (use: usual, ))
-------

-------

Entry 47 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Encounter/encounter-uspath-specimen-collection

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)

**identifier**:`http://example.com/fhir/encounters`/123**status**: completed**class**:inpatient encounter**type**:Pathology consultation, comprehensive, records and specimen with report**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**basedOn**:[ServiceRequest Surgical pathology study](ServiceRequest-servicerequest-cancer-path.md)
> **participant**

> **participant**

-------

Entry 48 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/ServiceRequest/servicerequest-cancer-path

Resource ServiceRequest:

> 

Profile: [US Pathology Service Request](StructureDefinition-us-pathology-service-request.md)

**status**: Active**intent**: Order**category**:Pathology**code**: No display for ServiceRequest.code (concept: Surgical pathology study)**subject**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**encounter**:[Encounter: identifier = http://example.com/fhir/encounters#123; status = finished; class = inpatient encounter (ActCode[9.0.0]#IMP); type = Pathology consultation, comprehensive, records and specimen with report](Encounter-encounter-uspath-specimen-collection.md)**occurrence**: 2025-03-18 17:00:14-0500**requester**:[PractitionerRole Ordering Provider](PractitionerRole-practitionerrole-uspath-surgeon.md)**specimen**:[Specimen: identifier = https://www.example.org/some-lis/fhir/specimen-identifier-provisioner#987654321; accessionIdentifier = https://www.example.org/some-lis/fhir/specimen-identifier-provisioner#987654321X; type = Tissue specimen (specimen)](Specimen-specimen-breast.md)

-------

Entry 49 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/PractitionerRole/practitionerrole-uspath-practitioner-oncologist

Resource PractitionerRole:

> 

Profile: [US Pathology Related Practitioner Role](StructureDefinition-us-pathology-related-practitioner-role.md)

**practitioner**:[Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)**organization**:[Organization Redwood Women's Center, P.C.](Organization-organization-Redwood-Womens-Center-PC.md)**code**:Ordering Provider

-------

Entry 50 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/PractitionerRole/practitionerrole-uspath-pathologist

Resource PractitionerRole:

> 

Profile: [US Pathology Related Practitioner Role](StructureDefinition-us-pathology-related-practitioner-role.md)

**practitioner**:[Practitioner Stains Alot](Practitioner-practitioner-pathologist.md)**organization**:[Organization Some Pathology Lab Name](Organization-organization-principal-pathology-lab.md)**code**:Primary Interpreter

-------

Entry 51 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/PractitionerRole/practitionerrole-uspath-surgeon

Resource PractitionerRole:

> 

Profile: [US Pathology Related Practitioner Role](StructureDefinition-us-pathology-related-practitioner-role.md)

**practitioner**:[Practitioner Cuts Alot](Practitioner-practitioner-surgeon.md)**organization**:[Organization Redwood Women's Center, P.C.](Organization-organization-Redwood-Womens-Center-PC.md)**code**:Ordering Provider

-------

Entry 52 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Organization/organization-Redwood-Womens-Center-PC

Resource Organization:

> 

Profile: [US Core Organization Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)

**active**: true**name**: Redwood Women's Center, P.C.

### Contacts

| | |
| :--- | :--- |
| - | **Address** |
| * | 3307 Renner Drive Fortuna CA 95540 USA |


-------

Entry 53 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Organization/organization-principal-pathology-lab

Resource Organization:

> 

Profile: [US Core Organization Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)

**active**: true**name**: Some Pathology Lab Name

### Contacts

| | |
| :--- | :--- |
| - | **Address** |
| * | Any City CA 95540 USA |


-------

Entry 54 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Practitioner/practitioner-pathologist

Resource Practitioner:

> 

Profile: [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)

**identifier**:[NPI](http://terminology.hl7.org/5.0.0/NamingSystem-npi.html)/1234567893**name**: Stains Alot

-------

Entry 55 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Practitioner/practitioner-oncologist

Resource Practitioner:

> 

Profile: [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)

**identifier**:[NPI](http://terminology.hl7.org/5.0.0/NamingSystem-npi.html)/1234567893**name**: Wise Owl

-------

Entry 56 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/Practitioner/practitioner-surgeon

Resource Practitioner:

> 

Profile: [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)

**identifier**:[NPI](http://terminology.hl7.org/5.0.0/NamingSystem-npi.html)/1234567893**name**: Cuts Alot

-------

Entry 57 - fullUrl = http://hl7.org/fhir/us/cancer-reporting/RelatedPerson/relatedperson-pathology-next-of-kin

Resource RelatedPerson:

> 

Profile: [US Core RelatedPerson Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-relatedperson.html)

**active**: true**patient**:[Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)**relationship**:Next-of-Kin**name**: Bill Hickok**telecom**: ph: 1-989-654-7896

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

